#include "temperaturesensor.h"
#include <cmath> //standard libary to give some important math functions
#include "Arduino.h"

const int PIN = A0;

using std::log;
using std::pow;

void TemperatureSensor::begin(){}

/*
  We use the static keyword to limit the visibility of helper functions
  to this implementation file.
*/

/*
  Get the "unknown" resistor using voltages and the known resistance
*/
static inline double getUnknownResistor(double v, double vdiv, double known_r){
  return known_r * vdiv / (v - vdiv);
}

/**
  This function uses information from the PANE 103395 datasheet, rev 0.
  Returns NAN if the resistance ratio is outside of the specified resistance
  ratios on the datasheet.
  Numeric values come from the datasheet.
*/
static double tempFromResistance(double r_r25){
  double a, b, c, d;
  if (r_r25 > 66.97){
    return NAN; //"Not a Number" ~= undefined. We're outside of the datasheet range!
  }
  else if (r_r25 > 3.279){
    // Coefficients taken from datasheet
    a = 3.357296E-03;
    b = 2.508334E-04;
    c = 4.189372E-06;
    d = -6.240867E-08;
  }
  else if (r_r25 > 0.3507){
    a = 3.354016E-03;
    b = 2.541522E-04;
    c = 3.730922E-06;
    d = -7.881561E-08;
  }
  else if (r_r25 > 0.0637){
    a = 3.361395E-03;
    b = 2.582266E-04;
    c = 5.885012E-07;
    d = -2.823586E-08;
  }
  else if (r_r25 > 0.0169){
    a = 3.351295E-03;
    b = 2.500181E-04;
    c = -1.7255607E-07;
    d = -4.356943E-08;
  }
  else{
    return NAN;
  }

  // Steinhart-Hart equation taken from datasheet (don't need to learn)
  return 1/(a + b*log(r_r25) + pow(c*b*log(r_r25),2) + pow(d*log(r_r25),3));
}

double PANE103395_VD::getTemperature(){
  double thermRes = getUnknownResistor(3.3, analogRead(PIN)*3.3/1024, mFixedRVal);
  return tempFromResistance(thermRes/mR25C);
}

MCP9808_I2C::MCP9808_I2C(Adafruit_MCP9808 & digitalTempSensor):
  mDigitalTempSensor(digitalTempSensor)
  {}

double MCP9808_I2C::getTemperature(){
  //you will implement this
}
