#ifndef TEMPERATURESENSOR_H
#define TEMPERATURESENSOR_H
#include <cstdint>
#include <Adafruit_MCP9808.h>

/**
 * "default" temperature sensor
 */
class TemperatureSensor {
  //Public members are accessible from other files
  public:
  virtual void begin();
  virtual double getTemperature() = 0;
  // We _can_ getTemperature() and receive a double, but we don't know how specifically.
  // Setting getTemperature() = 0 forces us to write a specific getTemperature()
  // function for every specific TemperatureSensor.
};

class PANE103395_VD:public TemperatureSensor { //a specific type of temperature sensor
  double mFixedRVal = 10000;
  double mR25C = 10000; 
  public:
  virtual double getTemperature() override;
  // override signals that getTemperature() from PANE103395_VD replaces the default
  void setFixedResistor(double newR);
};

class MCP9808_I2C:public TemperatureSensor { //another specific type of temperature sensor
  Adafruit_MCP9808 & mDigitalTempSensor;
  public:
  MCP9808_I2C() = delete; //You need to give your MCP9808_I2C an Adafruit_MCP9808 to work with.
  MCP9808_I2C(Adafruit_MCP9808 & digitalTempSensor);
  virtual double getTemperature() override;
};

//Here, we can specify other TemperatureSensors with their own versions of functions.

class TemperatureComparator{
  TemperatureSensor * mine;
  public:
  TemperatureComparator() = delete; //You need to give temperatureComparator a temperature sensor
  TemperatureComparator(TemperatureSensor * a);
  void doCompare(TemperatureSensor & other);
};
#endif
